/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.stOrthogonalLayout;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.BiconnectAugmentation;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.ConnectivityComponents;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.GraphOrientation;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.INode;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.GraphPointLayout;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.IPointLayouter;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Dart;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.EmbeddedGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.STPlanarGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.BiconnectedInitialEmbeddingFinder;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.ShortestPathEmbeddingFinder;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.TreeEmbeddingFinder;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.stOrthogonalLayout.OrthogonalFromVisibility;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.util.NodeMap;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import java.util.ArrayList;
import java.util.Map;

public class OrthogonalLayouter
implements IPointLayouter {
    @Override
    public GraphPointLayout doLayout(Graph graph) {
        Map<Node, Integer> components = ConnectivityComponents.getComponents(graph);
        int maxComponent = 0;
        for (Node node : ListSequence.fromList(graph.getNodes())) {
            maxComponent = Math.max(maxComponent, (Integer)MapSequence.fromMap(components).get(node));
        }
        NodeMap newNodes = new NodeMap(graph);
        IListSequence subgraphs = ListSequence.fromList(new ArrayList());
        for (int i = 0; i <= maxComponent; ++i) {
            ListSequence.fromList(subgraphs).addElement(new Graph());
        }
        for (Node node : ListSequence.fromList(graph.getNodes())) {
            Graph subgraph = (Graph)ListSequence.fromList(subgraphs).getElement((Integer)MapSequence.fromMap(components).get(node));
            MapSequence.fromMap(newNodes).put(node, subgraph.createNode());
        }
        for (Edge edge : ListSequence.fromList(graph.getEdges())) {
            Node source = (Node)MapSequence.fromMap(newNodes).get(edge.getSource());
            Graph subgraph = source.getGraph();
            subgraph.connect(source, (INode)MapSequence.fromMap(newNodes).get(edge.getTarget()));
        }
        return this.findSTLayout((Graph)ListSequence.fromList(subgraphs).getElement(0));
    }

    public GraphPointLayout findSTLayout(Graph graph) {
        BiconnectAugmentation.makeBiconnected(graph);
        int maxIndex = graph.getNumNodes();
        TreeEmbeddingFinder embeddingFinder = new TreeEmbeddingFinder();
        EmbeddedGraph embeddedGraph = new ShortestPathEmbeddingFinder(new BiconnectedInitialEmbeddingFinder()).find(graph);
        IListSequence<Object> outerNodes = ListSequence.fromList(new ArrayList());
        for (Dart dart : ListSequence.fromList(embeddedGraph.getOuterFace().getDarts())) {
            ListSequence.fromList(outerNodes).addElement(dart.getTarget());
        }
        outerNodes = ListSequence.fromList(outerNodes).where(it -> it.getIndex() < maxIndex).toListSequence();
        Node s = (Node)ListSequence.fromList(outerNodes).getElement(0);
        Node t = (Node)ListSequence.fromList(outerNodes).getElement(ListSequence.fromList(outerNodes).count() / 2);
        GraphOrientation.orientST(graph, s, t);
        STPlanarGraph stPlanarGraph = new STPlanarGraph(embeddedGraph, s, t);
        return new OrthogonalFromVisibility().doLayout(stPlanarGraph);
    }
}

