/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.stOrthogonalLayout;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.BiconnectAugmentation;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.ConnectivityComponents;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.GraphOrientation;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.EdgesHistoryManager;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.IEdge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.INode;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.GraphLayout;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.GraphLayoutFactory;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Dimension;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.OrthogonalUtil;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Point;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Rectangle;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Dart;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.EmbeddedGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.STPlanarGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.PQPlanarizationFinder;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.ShortestPathEmbeddingFinder;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.stOrthogonalLayout.ConstraintsSupporter;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.stOrthogonalLayout.LayoutOptimizer;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.util.NodeMap;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IMapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISelector;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RectOrthogonalLayouter {
    private static final int DEFAULT_NODE_SIZE = 20;
    private static final int DEFAULT_EDGE_DISTANCE = 30;
    private int myNodeSize = 20;
    private int myEdgeDistance = 30;
    private int myLayoutLevel = 1;
    private Map<Edge, Edge> myMovedLabels = MapSequence.fromMap(new HashMap());

    public GraphLayout doLayout(Graph graph, Map<Node, Dimension> nodeSizes, Map<Edge, Dimension> edgeSizes) {
        Object subgraph;
        Map<Node, Integer> components = ConnectivityComponents.getComponents(graph);
        int maxComponent = 0;
        for (Node node : ListSequence.fromList(graph.getNodes())) {
            maxComponent = Math.max(maxComponent, (Integer)MapSequence.fromMap(components).get(node));
        }
        NodeMap newNodes = new NodeMap(graph);
        NodeMap nodeSubgraphs = new NodeMap(graph);
        IMapSequence newEdges = MapSequence.fromMap(new HashMap());
        IListSequence subgraphs = ListSequence.fromList(new ArrayList());
        IMapSequence subNodeSizes = MapSequence.fromMap(new HashMap());
        IMapSequence subEdgeSizes = MapSequence.fromMap(new HashMap());
        for (int i = 0; i <= maxComponent; ++i) {
            Graph subgraph2 = ListSequence.fromList(subgraphs).addElement(new Graph());
            MapSequence.fromMap(subNodeSizes).put(subgraph2, MapSequence.fromMap(new HashMap()));
            MapSequence.fromMap(subEdgeSizes).put(subgraph2, MapSequence.fromMap(new HashMap()));
        }
        for (Node node : ListSequence.fromList(graph.getNodes())) {
            subgraph = (Graph)ListSequence.fromList(subgraphs).getElement((Integer)MapSequence.fromMap(components).get(node));
            Node newNode = ((Graph)subgraph).createNode();
            MapSequence.fromMap(newNodes).put(node, newNode);
            MapSequence.fromMap(nodeSubgraphs).put(node, subgraph);
            MapSequence.fromMap((Map)MapSequence.fromMap(subNodeSizes).get(subgraph)).put(newNode, new Dimension(((Dimension)MapSequence.fromMap(nodeSizes).get((Object)node)).width + this.myEdgeDistance, ((Dimension)MapSequence.fromMap(nodeSizes).get((Object)node)).height));
        }
        for (Edge edge : ListSequence.fromList(graph.getEdges())) {
            subgraph = (Graph)MapSequence.fromMap(nodeSubgraphs).get(edge.getSource());
            Edge newEdge = ((Graph)subgraph).connect((INode)MapSequence.fromMap(newNodes).get(edge.getSource()), (INode)MapSequence.fromMap(newNodes).get(edge.getTarget()));
            MapSequence.fromMap(newEdges).put(edge, newEdge);
            if (MapSequence.fromMap(edgeSizes).get(edge) == null) {
                MapSequence.fromMap((Map)MapSequence.fromMap(subEdgeSizes).get(subgraph)).put(newEdge, new Dimension(this.myEdgeDistance, this.myEdgeDistance));
                continue;
            }
            MapSequence.fromMap((Map)MapSequence.fromMap(subEdgeSizes).get(subgraph)).put(newEdge, new Dimension(((Dimension)MapSequence.fromMap(edgeSizes).get((Object)edge)).width + this.myEdgeDistance, ((Dimension)MapSequence.fromMap(edgeSizes).get((Object)edge)).height + this.myEdgeDistance));
        }
        IMapSequence subgraphLayouts = MapSequence.fromMap(new HashMap());
        int shiftX = 0;
        for (Graph subgraph3 : ListSequence.fromList(subgraphs)) {
            GraphLayout curLayout = this.findSTLayout(subgraph3, (Map)MapSequence.fromMap(subNodeSizes).get(subgraph3), (Map)MapSequence.fromMap(subEdgeSizes).get(subgraph3));
            curLayout = curLayout.shift(shiftX, 0);
            MapSequence.fromMap(subgraphLayouts).put(subgraph3, curLayout);
            shiftX = curLayout.getContainingRectangle().x + curLayout.getContainingRectangle().width + 30;
        }
        GraphLayout layout = GraphLayoutFactory.createGraphLayout(graph);
        for (Node node : ListSequence.fromList(graph.getNodes())) {
            Graph subgraph4 = (Graph)MapSequence.fromMap(nodeSubgraphs).get(node);
            layout.setLayoutFor(node, ((GraphLayout)MapSequence.fromMap(subgraphLayouts).get(subgraph4)).getNodeLayout((INode)MapSequence.fromMap(newNodes).get(node)));
        }
        for (Edge edge : ListSequence.fromList(graph.getEdges())) {
            GraphLayout subgraphLayout = (GraphLayout)MapSequence.fromMap(subgraphLayouts).get(MapSequence.fromMap(nodeSubgraphs).get(edge.getSource()));
            layout.setLayoutFor(edge, (List<Point>)subgraphLayout.getEdgeLayout((IEdge)MapSequence.fromMap(newEdges).get(edge)));
            if (!MapSequence.fromMap(edgeSizes).containsKey(edge)) continue;
            layout.setLabelLayout(edge, subgraphLayout.getLabelLayout((IEdge)MapSequence.fromMap(this.myMovedLabels).get(MapSequence.fromMap(newEdges).get(edge))));
        }
        if (this.myLayoutLevel == 0) {
            return (GraphLayout)MapSequence.fromMap(subgraphLayouts).get(ListSequence.fromList(subgraphs).getElement(0));
        }
        return layout;
    }

    public GraphLayout findSTLayout(Graph graph, Map<Node, Dimension> nodeSizes, Map<Edge, Dimension> edgeSizes) {
        if (graph.getNumNodes() == 1) {
            GraphLayout layout = GraphLayoutFactory.createGraphLayout(graph);
            Node node = graph.getNode(0);
            layout.setLayoutFor(node, new Rectangle(20, 20, ((Dimension)MapSequence.fromMap(nodeSizes).get((Object)node)).width - this.myEdgeDistance, ((Dimension)MapSequence.fromMap(nodeSizes).get((Object)node)).height));
            return layout;
        }
        IListSequence<Edge> oldEdges = ListSequence.fromList(new ArrayList());
        ListSequence.fromList(oldEdges).addSequence((ISequence)ListSequence.fromList(graph.getEdges()));
        BiconnectAugmentation.makeBiconnected(graph);
        Node addedNode = (Node)ListSequence.fromList(graph.getNodes()).last();
        EdgesHistoryManager historyManager = new EdgesHistoryManager(graph);
        EmbeddedGraph embeddedGraph = new ShortestPathEmbeddingFinder(new PQPlanarizationFinder()).find(graph);
        for (Node node : ListSequence.fromList(graph.getNodes())) {
            if (MapSequence.fromMap(nodeSizes).containsKey(node)) continue;
            MapSequence.fromMap(nodeSizes).put(node, new Dimension(this.myNodeSize, this.myNodeSize));
        }
        IMapSequence<Edge, Dimension> newEdgeSizes = MapSequence.fromMap(new HashMap());
        ISetSequence<Edge> hasLabel = SetSequence.fromSet(new HashSet());
        for (Edge oldEdge : ListSequence.fromList(oldEdges)) {
            List<Edge> history = historyManager.getHistory(oldEdge);
            Node cur = oldEdge.getSource();
            if (!ListSequence.fromList(((Edge)ListSequence.fromList(history).first()).getAdjacentNodes()).contains(cur)) {
                history = ListSequence.fromList(history).reversedList();
            }
            Edge midEdge = ListSequence.fromList(history).getElement(ListSequence.fromList(history).count() / 2);
            for (Edge edge : ListSequence.fromList(history)) {
                if (edge == midEdge && MapSequence.fromMap(edgeSizes).get(oldEdge) != null) {
                    MapSequence.fromMap(newEdgeSizes).put(edge, (Dimension)MapSequence.fromMap(edgeSizes).get(oldEdge));
                    MapSequence.fromMap(this.myMovedLabels).put(oldEdge, edge);
                    SetSequence.fromSet(hasLabel).addElement(edge);
                    continue;
                }
                MapSequence.fromMap(newEdgeSizes).put(edge, new Dimension(this.myEdgeDistance, this.myEdgeDistance));
            }
        }
        for (Object edge : ListSequence.fromList(graph.getEdges())) {
            if (MapSequence.fromMap(newEdgeSizes).get(edge) != null) continue;
            MapSequence.fromMap(newEdgeSizes).put(edge, new Dimension(this.myEdgeDistance, this.myEdgeDistance));
        }
        IListSequence outerNodes = ListSequence.fromList(new ArrayList());
        for (Dart dart : ListSequence.fromList(embeddedGraph.getOuterFace().getDarts())) {
            ListSequence.fromList(outerNodes).addElement(dart.getTarget());
        }
        Node s = (Node)ListSequence.fromList(outerNodes).getElement(0);
        Node t = (Node)ListSequence.fromList(outerNodes).getElement(ListSequence.fromList(outerNodes).count() / 2);
        GraphOrientation.orientST(graph, s, t);
        STPlanarGraph stPlanarGraph = new STPlanarGraph(embeddedGraph, s, t);
        ConstraintsSupporter supporter = new ConstraintsSupporter();
        supporter.setMinEdgeDistance(this.myEdgeDistance, 15);
        Map<Object, Rectangle> representation = supporter.getRepresentation(stPlanarGraph, nodeSizes, newEdgeSizes);
        GraphLayout graphLayout = this.createLayout(graph, representation, nodeSizes, newEdgeSizes, hasLabel);
        if (this.myLayoutLevel > 0) {
            this.removeTempObjects(oldEdges, graphLayout, graph, addedNode, historyManager);
        }
        if (this.myLayoutLevel > 1) {
            LayoutOptimizer.optimizeEdges(graphLayout);
        }
        return graphLayout;
    }

    private void removeTempObjects(List<Edge> oldEdges, GraphLayout graphLayout, Graph graph, Node addedNode, EdgesHistoryManager manager) {
        ISetSequence visited = SetSequence.fromSet(new HashSet());
        for (Edge oldEdge : ListSequence.fromList(oldEdges)) {
            List<Edge> history = manager.getHistory(oldEdge);
            Node cur = oldEdge.getSource();
            if (ListSequence.fromList(history).count() > 1) {
                Point beforeLast;
                Point second;
                Rectangle targetRect;
                IListSequence<Point> oldEdgeLayout = ListSequence.fromList(new ArrayList());
                Iterable sourceHistoryPath = graphLayout.getEdgeLayout((IEdge)ListSequence.fromList(history).first());
                Point sourcePoint = ((Edge)ListSequence.fromList(history).first()).getSource() == oldEdge.getSource() ? new Point((Point)ListSequence.fromList(sourceHistoryPath).first()) : new Point((Point)ListSequence.fromList(sourceHistoryPath).last());
                Iterable targetHistoryPath = graphLayout.getEdgeLayout((IEdge)ListSequence.fromList(history).last());
                Point targetPoint = ((Edge)ListSequence.fromList(history).last()).getTarget() == oldEdge.getTarget() ? new Point((Point)ListSequence.fromList(targetHistoryPath).last()) : new Point((Point)ListSequence.fromList(targetHistoryPath).first());
                Edge prev = null;
                for (Edge edge : ListSequence.fromList(history)) {
                    IListSequence edgeLayout = graphLayout.getEdgeLayout(edge);
                    if (edge.getSource() != cur) {
                        edgeLayout = ListSequence.fromList(edgeLayout).reversedList();
                    }
                    if (cur.isDummy()) {
                        int y;
                        Rectangle rect = graphLayout.getNodeLayout(cur);
                        if (SetSequence.fromSet(visited).contains(cur)) {
                            y = rect.y + rect.height;
                            int shift = this.myEdgeDistance / 3;
                            int last = ListSequence.fromList(oldEdgeLayout).count() - 1;
                            ((Point)ListSequence.fromList(oldEdgeLayout).getElement(last)).translate(shift, 0);
                            ((Point)ListSequence.fromList(oldEdgeLayout).getElement(last - 1)).translate(shift, 0);
                            ((Point)ListSequence.fromList(edgeLayout).getElement(0)).translate(shift, 0);
                            ((Point)ListSequence.fromList(edgeLayout).getElement(1)).translate(shift, 0);
                            Rectangle labelRect = graphLayout.getLabelLayout(edge);
                            if (labelRect != null) {
                                labelRect.setLocation(labelRect.x + shift, labelRect.y);
                            }
                            if (prev != null && (labelRect = graphLayout.getLabelLayout(prev)) != null) {
                                labelRect.setLocation(labelRect.x + shift, labelRect.y);
                            }
                        } else {
                            y = rect.y;
                            SetSequence.fromSet(visited).addElement(cur);
                        }
                        Point left = (Point)ListSequence.fromList(edgeLayout).removeLastElement();
                        Point right = (Point)ListSequence.fromList(edgeLayout).removeElementAt(0);
                        ListSequence.fromList(oldEdgeLayout).addElement(new Point(left.x, y));
                        ListSequence.fromList(edgeLayout).insertElement(0, new Point(right.x, y));
                        prev = edge;
                    }
                    ListSequence.fromList(oldEdgeLayout).addSequence((ISequence)ListSequence.fromList(edgeLayout));
                    cur = edge.getOpposite(cur);
                }
                Rectangle sourceRect = graphLayout.getNodeLayout(oldEdge.getSource());
                if (sourceRect.contains((Point)ListSequence.fromList(oldEdgeLayout).first())) {
                    ListSequence.fromList(oldEdgeLayout).insertElement(0, sourcePoint);
                }
                if ((targetRect = graphLayout.getNodeLayout(oldEdge.getTarget())).contains((Point)ListSequence.fromList(oldEdgeLayout).last())) {
                    ListSequence.fromList(oldEdgeLayout).addElement(targetPoint);
                }
                if (sourceRect.contains(second = (Point)ListSequence.fromList(oldEdgeLayout).getElement(1))) {
                    ListSequence.fromList(oldEdgeLayout).removeElementAt(0);
                    ListSequence.fromList(oldEdgeLayout).removeElementAt(0);
                    ListSequence.fromList(oldEdgeLayout).insertElement(0, OrthogonalUtil.findOnBorder(sourceRect, second, (Point)ListSequence.fromList(oldEdgeLayout).first()));
                }
                if (targetRect.contains(beforeLast = (Point)ListSequence.fromList(oldEdgeLayout).getElement(ListSequence.fromList(oldEdgeLayout).count() - 2))) {
                    ListSequence.fromList(oldEdgeLayout).removeLastElement();
                    ListSequence.fromList(oldEdgeLayout).removeLastElement();
                    ListSequence.fromList(oldEdgeLayout).addElement(OrthogonalUtil.findOnBorder(targetRect, beforeLast, (Point)ListSequence.fromList(oldEdgeLayout).last()));
                }
                graphLayout.setLayoutFor(oldEdge, oldEdgeLayout);
                continue;
            }
            Edge newEdge = ListSequence.fromList(history).getElement(0);
            graphLayout.setLayoutFor(oldEdge, (List<Point>)graphLayout.getEdgeLayout(newEdge));
        }
        IListSequence<Node> nodesToRemove = ListSequence.fromList(graph.getNodes()).where(it -> it.isDummy()).toListSequence();
        ListSequence.fromList(nodesToRemove).addElement(addedNode);
        for (Node node : ListSequence.fromList(nodesToRemove)) {
            MapSequence.fromMap(graphLayout.getNodeLayout()).removeKey(node);
            for (Edge edge : ListSequence.fromList(node.getEdges())) {
                MapSequence.fromMap(graphLayout.getEdgeLayout()).removeKey(edge);
            }
        }
    }

    private GraphLayout createLayout(Graph graph, Map<Object, Rectangle> representation, Map<Node, Dimension> nodeSizes, Map<Edge, Dimension> edgeSizes, Set<Edge> hasLabels) {
        GraphLayout layout = GraphLayoutFactory.createGraphLayout(graph);
        for (Node node : ListSequence.fromList(graph.getNodes())) {
            Rectangle rect = (Rectangle)MapSequence.fromMap(representation).get(node);
            if (!node.isDummy()) {
                int width = ((Dimension)MapSequence.fromMap(nodeSizes).get((Object)node)).width - this.myEdgeDistance;
                int meanEdgeX = 0;
                Iterable edges = node.getEdges();
                for (Edge edge : ListSequence.fromList(edges)) {
                    meanEdgeX += ((Rectangle)MapSequence.fromMap(representation).get((Object)edge)).x;
                }
                int nodeX = (meanEdgeX /= ListSequence.fromList(edges).count()) - width / 2;
                if (nodeX < rect.x) {
                    nodeX = rect.x;
                }
                if (nodeX + width > rect.x + rect.width) {
                    nodeX = rect.x + rect.width - width;
                }
                layout.setLayoutFor(node, new Rectangle(nodeX, rect.y, width, ((Dimension)MapSequence.fromMap(nodeSizes).get((Object)node)).height));
                continue;
            }
            layout.setLayoutFor(node, rect);
        }
        for (Edge edge : ListSequence.fromList(graph.getEdges())) {
            Rectangle edgeRect = (Rectangle)MapSequence.fromMap(representation).get(edge);
            if (SetSequence.fromSet(hasLabels).contains(edge)) {
                Dimension labelSize = (Dimension)MapSequence.fromMap(edgeSizes).get(edge);
                int mid = edgeRect.y + edgeRect.height / 2;
                int height = labelSize.height - this.myEdgeDistance;
                Rectangle labelRectangle = new Rectangle(edgeRect.x, mid - height / 2, labelSize.width - this.myEdgeDistance, height);
                layout.setLabelLayout(edge, labelRectangle);
            }
            IListSequence<Point> path = ListSequence.fromList(new ArrayList());
            Rectangle sourceRect = layout.getNodeLayout(edge.getSource());
            int sourceMinX = sourceRect.x;
            int sourceMaxX = sourceRect.x + sourceRect.width;
            int edgeX = edgeRect.x;
            boolean hasHorLines = false;
            if (sourceMaxX < edgeX) {
                ListSequence.fromList(path).addElement(new Point(sourceMaxX, sourceRect.y + sourceRect.height / 2));
                hasHorLines = true;
            }
            if (edgeX < sourceMinX) {
                ListSequence.fromList(path).addElement(new Point(sourceMinX, sourceRect.y + sourceRect.height / 2));
                hasHorLines = true;
            }
            if (hasHorLines) {
                ListSequence.fromList(path).addElement(new Point(edgeX, sourceRect.y + sourceRect.height / 2));
            } else {
                ListSequence.fromList(path).addElement(new Point(edgeX, sourceRect.y + sourceRect.height));
            }
            Rectangle targetRect = layout.getNodeLayout(edge.getTarget());
            int targetMinX = targetRect.x;
            int targetMaxX = targetRect.x + targetRect.width;
            hasHorLines = false;
            Point end = null;
            if (targetMaxX < edgeX) {
                end = new Point(targetMaxX, targetRect.y + targetRect.height / 2);
                hasHorLines = true;
            }
            if (edgeX < targetMinX) {
                end = new Point(targetMinX, targetRect.y + targetRect.height / 2);
                hasHorLines = true;
            }
            if (hasHorLines) {
                ListSequence.fromList(path).addElement(new Point(edgeX, targetRect.y + targetRect.height / 2));
                ListSequence.fromList(path).addElement(end);
            } else {
                ListSequence.fromList(path).addElement(new Point(edgeX, targetRect.y));
            }
            layout.setLayoutFor(edge, path);
        }
        layout = layout.shift(20, 20);
        this.correctEdgesLayout(layout);
        return layout;
    }

    public void correctEdgesLayout(GraphLayout layout) {
        Graph graph = (Graph)layout.getGraph();
        for (Node node : ListSequence.fromList(graph.getNodes())) {
            this.correctEdgesFromNode(layout, node, layout.getNodeLayout((INode)node).x);
            this.correctEdgesFromNode(layout, node, layout.getNodeLayout((INode)node).x + layout.getNodeLayout((INode)node).width);
        }
    }

    private void correctEdgesFromNode(GraphLayout layout, Node node, final int xCoord) {
        List path;
        Map<IEdge, List<Point>> edgeLayout = layout.getEdgeLayout();
        Rectangle rect = layout.getNodeLayout(node);
        IListSequence<Object> sourceEdges = ListSequence.fromList(new ArrayList());
        IListSequence<Object> targetEdges = ListSequence.fromList(new ArrayList());
        final IMapSequence adjPoint = MapSequence.fromMap(new HashMap());
        for (Edge edge : ListSequence.fromList(node.getOutEdges())) {
            List path2 = (List)MapSequence.fromMap(edgeLayout).get(edge);
            if (((Point)ListSequence.fromList(path2).getElement((int)0)).y != ((Point)ListSequence.fromList(path2).getElement((int)1)).y) continue;
            Point connectingPoint = (Point)ListSequence.fromList(path2).first();
            if (connectingPoint.x != xCoord) continue;
            ListSequence.fromList(sourceEdges).addElement(edge);
            MapSequence.fromMap(adjPoint).put(edge, (Point)ListSequence.fromList(path2).getElement(1));
        }
        for (Edge edge : ListSequence.fromList(node.getInEdges())) {
            List path2 = (List)MapSequence.fromMap(edgeLayout).get(edge);
            int size = ListSequence.fromList(path2).count();
            if (((Point)ListSequence.fromList(path2).getElement((int)(size - 1))).y != ((Point)ListSequence.fromList(path2).getElement((int)(size - 2))).y) continue;
            Point connectingPoint = (Point)ListSequence.fromList(path2).last();
            if (connectingPoint.x != xCoord) continue;
            ListSequence.fromList(targetEdges).addElement(edge);
            MapSequence.fromMap(adjPoint).put(edge, (Point)ListSequence.fromList(path2).getElement(size - 2));
        }
        int num = ListSequence.fromList(sourceEdges).count() + ListSequence.fromList(targetEdges).count() + 1;
        sourceEdges = ListSequence.fromList(sourceEdges).sort(new ISelector<Edge, Integer>(this){

            @Override
            public Integer select(Edge it) {
                return Math.abs(((Point)MapSequence.fromMap(adjPoint).get((Object)it)).x - xCoord);
            }
        }, false).toListSequence();
        targetEdges = ListSequence.fromList(targetEdges).sort(new ISelector<Edge, Integer>(this){

            @Override
            public Integer select(Edge it) {
                return Math.abs(((Point)MapSequence.fromMap(adjPoint).get((Object)it)).x - xCoord);
            }
        }, true).toListSequence();
        int step = rect.height / num;
        int curY = rect.y + step;
        for (Edge edge : ListSequence.fromList(targetEdges)) {
            path = (List)MapSequence.fromMap(edgeLayout).get(edge);
            int size = ListSequence.fromList(path).count();
            ListSequence.fromList(path).setElement(size - 1, new Point(((Point)ListSequence.fromList(path).getElement((int)(size - 1))).x, curY));
            ListSequence.fromList(path).setElement(size - 2, new Point(((Point)ListSequence.fromList(path).getElement((int)(size - 2))).x, curY));
            curY += step;
        }
        for (Edge edge : ListSequence.fromList(sourceEdges)) {
            path = (List)MapSequence.fromMap(edgeLayout).get(edge);
            ListSequence.fromList(path).setElement(0, new Point(((Point)ListSequence.fromList(path).getElement((int)0)).x, curY));
            ListSequence.fromList(path).setElement(1, new Point(((Point)ListSequence.fromList(path).getElement((int)1)).x, curY));
            curY += step;
        }
    }

    public void setNodeSize(int nodeSize) {
        this.myNodeSize = nodeSize;
    }

    public void setEdgeDistance(int edgeDistance) {
        this.myEdgeDistance = edgeDistance;
    }

    public void setLayoutLevel(int level) {
        this.myLayoutLevel = level;
    }
}

