/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime;

import com.vertabelo.autolayout_tool.repackaged.mps.baseLanguage.closures.runtime.AdapterClass;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.AbstractSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ICollectionSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISequence;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;

public abstract class AbstractCollectionSequence<T>
extends AbstractSequence<T>
implements ICollectionSequence<T>,
Collection<T> {
    protected AbstractCollectionSequence() {
    }

    @Override
    public T addElement(T t) {
        if (this.getCollection().add(t)) {
            return t;
        }
        return null;
    }

    @Override
    public T removeElement(T t) {
        if (this.remove(t)) {
            return t;
        }
        return null;
    }

    @Override
    public ICollectionSequence<T> addSequence(ISequence<? extends T> seq) {
        if (seq == null) {
            return this;
        }
        if (seq.toIterable() instanceof Collection) {
            this.getCollection().addAll((Collection)seq.toIterable());
        } else {
            for (T t : seq.toIterable()) {
                this.getCollection().add(t);
            }
        }
        return this;
    }

    @Override
    public ICollectionSequence<T> removeSequence(ISequence<? extends T> seq) {
        if (seq == null) {
            return this;
        }
        if (seq.toIterable() instanceof Collection) {
            this.getCollection().removeAll((Collection)seq.toIterable());
        } else {
            for (T t : seq.toIterable()) {
                this.getCollection().remove(t);
            }
        }
        return this;
    }

    @Override
    public ICollectionSequence<T> removeWhere(@AdapterClass(value="IWhereFilter") Predicate<? super T> filter) {
        Iterator<T> it = this.getCollection().iterator();
        while (it.hasNext()) {
            if (!filter.test(it.next())) continue;
            it.remove();
        }
        return this;
    }

    @Override
    public boolean add(T e) {
        return this.getCollection().add(e);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.getCollection().addAll(c);
    }

    @Override
    public void clear() {
        this.getCollection().clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.getCollection().contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getCollection().containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.getCollection().isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        return this.getCollection().remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.getCollection().removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.getCollection().retainAll(c);
    }

    @Override
    public int size() {
        return this.getCollection().size();
    }

    @Override
    public Object[] toArray() {
        return this.getCollection().toArray();
    }

    @Override
    public <U> U[] toArray(U[] a) {
        return this.getCollection().toArray(a);
    }

    @Override
    public Iterator<T> iterator() {
        return this.getCollection().iterator();
    }

    @Override
    public int count() {
        return this.getCollection().size();
    }

    @Override
    public boolean containsSequence(ISequence<? extends T> that) {
        if (that instanceof AbstractCollectionSequence) {
            return this.getCollection().containsAll(((AbstractCollectionSequence)that).getCollection());
        }
        return super.containsSequence(that);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof AbstractCollectionSequence) {
            Collection<T> thatColl = ((AbstractCollectionSequence)o).getCollection();
            Collection<T> thisColl = this.getCollection();
            if (thisColl == thatColl) {
                return true;
            }
            return thisColl != null ? thisColl.equals(thatColl) : false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return this.getCollection().hashCode();
    }

    protected abstract Collection<T> getCollection();
}

