/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime;

import com.vertabelo.autolayout_tool.repackaged.mps.baseLanguage.closures.runtime.AdapterClass;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.AbstractCollectionSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ArrayUtils;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISequence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;

public abstract class AbstractListSequence<T>
extends AbstractCollectionSequence<T>
implements IListSequence<T>,
List<T>,
Serializable {
    private static final long serialVersionUID = -2967185763228867218L;
    private List<T> list;

    protected AbstractListSequence(List<T> list) {
        this.setList(list);
    }

    protected AbstractListSequence(AbstractListSequence<T> other) {
        this.setList(new ArrayList<T>(other.getList()));
    }

    protected AbstractListSequence() {
    }

    @Override
    public void add(int index, T element) {
        this.getList().add(index, element);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.getList().addAll(index, c);
    }

    @Override
    public int indexOf(Object o) {
        return this.getList().indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.getList().isEmpty();
    }

    @Override
    public T get(int index) {
        return this.getList().get(index);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.getList().lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.getList().listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.getList().listIterator(index);
    }

    @Override
    public T remove(int index) {
        return this.getList().remove(index);
    }

    @Override
    public T set(int index, T element) {
        return this.getList().set(index, element);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.getList().subList(fromIndex, toIndex);
    }

    @Override
    public T first() {
        if (!this.getList().isEmpty()) {
            return this.getList().getFirst();
        }
        return null;
    }

    @Override
    public T last() {
        if (!this.getList().isEmpty()) {
            return this.getList().getLast();
        }
        return null;
    }

    @Override
    public boolean isNotEmpty() {
        return !this.getList().isEmpty();
    }

    @Override
    public T removeElementAt(int idx) {
        if (this.size() == 0 && (idx == 0 || idx == -1)) {
            return null;
        }
        return this.remove(idx);
    }

    @Override
    public T removeLastElement() {
        if (this.size() == 0) {
            return null;
        }
        return this.remove(this.size() - 1);
    }

    @Override
    public T insertElement(int idx, T t) {
        this.add(idx, t);
        return t;
    }

    @Override
    public T getElement(int idx) {
        if (this.size() == 0 && (idx == 0 || idx == -1)) {
            return null;
        }
        return this.get(idx);
    }

    @Override
    public T setElement(int idx, T t) {
        if (this.size() == 0 && (idx == 0 || idx == -1)) {
            return null;
        }
        this.set(idx, t);
        return t;
    }

    @Override
    public IListSequence<T> addSequence(ISequence<? extends T> seq) {
        return (IListSequence)super.addSequence(seq);
    }

    @Override
    public IListSequence<T> removeSequence(ISequence<? extends T> seq) {
        return (IListSequence)super.removeSequence(seq);
    }

    @Override
    public IListSequence<T> removeWhere(@AdapterClass(value="IWhereFilter") Predicate<? super T> filter) {
        return (IListSequence)super.removeWhere(filter);
    }

    @Override
    public T[] toGenericArray() {
        return this.getList().toArray();
    }

    @Override
    public T[] toGenericArray(Class<T> runtimeClass) {
        Object[] arr = (Object[])ArrayUtils.newArrayInstance(runtimeClass, this.getList().size());
        return this.getList().toArray(arr);
    }

    @Override
    public List<T> toList() {
        return this;
    }

    @Override
    public IListSequence<T> toListSequence() {
        return this;
    }

    void _reverse() {
        Collections.reverse(this.getList());
    }

    @Override
    protected List<T> getCollection() {
        return this.list;
    }

    protected List<T> getList() {
        return this.list;
    }

    private void setList(List<T> list) {
        this.list = list;
    }
}

