/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime;

import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.AbstractCollectionSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.AbstractSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ArrayUtils;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IMapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IMapping;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISetSequence;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractMapSequence<U, V>
extends AbstractSequence<IMapping<U, V>>
implements IMapSequence<U, V>,
Map<U, V>,
Serializable {
    private static final long serialVersionUID = -1214142666318630447L;
    private Map<U, V> map;

    protected AbstractMapSequence(Map<U, V> map) {
        this.map = map;
    }

    protected AbstractMapSequence() {
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<U, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<U> keySet() {
        return this.map.keySet();
    }

    @Override
    public V put(U key, V value) {
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends U, ? extends V> m) {
        this.map.putAll(m);
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public boolean contains(Object o) {
        V v = this.map.get(((IMapping)o).key());
        return this.eq(v, ((IMapping)o).value());
    }

    @Override
    public int count() {
        return this.map.size();
    }

    @Override
    public ISequence<IMapping<U, V>> distinct() {
        return this;
    }

    @Override
    public boolean isNotEmpty() {
        return !this.map.isEmpty();
    }

    @Override
    public Iterator<IMapping<U, V>> iterator() {
        return new MappingIterator(this);
    }

    @Override
    public IMapSequence<U, V> putAll(IMapSequence<? extends U, ? extends V> map) {
        this.getMap().putAll(map);
        return this;
    }

    @Override
    public V removeKey(U u) {
        return this.getMap().remove(u);
    }

    @Override
    public V putValue(U key, V value) {
        this.getMap().put(key, value);
        return value;
    }

    @Override
    public Map<U, V> toMap() {
        return this;
    }

    @Override
    public ISetSequence<IMapping<U, V>> mappingsSet() {
        return new MappingsSetSequence();
    }

    protected Map<U, V> getMap() {
        return this.map;
    }

    private boolean eq(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    private class MappingIterator
    implements Iterator<IMapping<U, V>> {
        private Iterator<Map.Entry<U, V>> entriesIt;

        public MappingIterator(AbstractMapSequence abstractMapSequence) {
            this.entriesIt = abstractMapSequence.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.entriesIt.hasNext();
        }

        @Override
        public IMapping<U, V> next() {
            return new EntryMapping(this.entriesIt.next());
        }

        @Override
        public void remove() {
            this.entriesIt.remove();
        }
    }

    private class MappingsSetSequence
    extends AbstractCollectionSequence<IMapping<U, V>>
    implements ISetSequence<IMapping<U, V>>,
    Set<IMapping<U, V>> {
        private MappingsSetSequence() {
        }

        @Override
        public IMapping<U, V> addElement(IMapping<U, V> t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ISetSequence<IMapping<U, V>> addSequence(ISequence<? extends IMapping<U, V>> seq) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IMapping<U, V> removeElement(IMapping<U, V> t) {
            if (AbstractMapSequence.this.map.entrySet().remove(t.toEntry())) {
                return t;
            }
            return null;
        }

        @Override
        public ISetSequence<IMapping<U, V>> removeSequence(ISequence<? extends IMapping<U, V>> seq) {
            if (seq == null) {
                return this;
            }
            for (IMapping t : seq.toIterable()) {
                AbstractMapSequence.this.map.entrySet().remove(t.toEntry());
            }
            return this;
        }

        @Override
        public boolean contains(Object o) {
            return AbstractMapSequence.this.map.entrySet().contains(((IMapping)o).toEntry());
        }

        public IMapping<U, V>[] toGenericArray() {
            IMapping[] result = (IMapping[])ArrayUtils.newArrayInstance(IMapping.class, this.size());
            Iterator it = AbstractMapSequence.this.iterator();
            int i = 0;
            while (it.hasNext()) {
                result[i] = it.next();
                ++i;
            }
            return result;
        }

        public IMapping<U, V>[] toGenericArray(Class runtimeClass) {
            IMapping[] arr = (IMapping[])ArrayUtils.newArrayInstance(runtimeClass, this.size());
            return this.toArray(arr);
        }

        @Override
        public Set toSet() {
            return this;
        }

        @Override
        public Iterator iterator() {
            return AbstractMapSequence.this.iterator();
        }

        @Override
        public boolean add(IMapping<U, V> o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            AbstractMapSequence.this.map.entrySet().clear();
        }

        @Override
        public boolean containsAll(Collection c) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                if (AbstractMapSequence.this.map.entrySet().contains((IMapping)it.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean remove(Object o) {
            return AbstractMapSequence.this.map.entrySet().remove((IMapping)o);
        }

        @Override
        public boolean removeAll(Collection c) {
            boolean modified = false;
            Iterator it = this.iterator();
            while (it.hasNext()) {
                if (!c.contains(it.next())) continue;
                it.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(Collection c) {
            boolean modified = false;
            Iterator it = this.iterator();
            while (it.hasNext()) {
                if (c.contains(it.next())) continue;
                it.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public int size() {
            return AbstractMapSequence.this.map.entrySet().size();
        }

        @Override
        public Object[] toArray() {
            return this.toGenericArray();
        }

        public IMapping<U, V>[] toArray(IMapping<U, V>[] arr) {
            int size = this.size();
            if (arr.length < size) {
                arr = (IMapping[])ArrayUtils.newArrayInstance(arr.getClass().getComponentType(), size);
            }
            Iterator it = this.iterator();
            for (int i = 0; i < size; ++i) {
                arr[i] = (IMapping)it.next();
            }
            if (arr.length > size) {
                arr[size] = null;
            }
            return arr;
        }

        @Override
        public ISetSequence<IMapping<U, V>> asUnmodifiable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ISetSequence<IMapping<U, V>> asSynchronized() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Collection getCollection() {
            return AbstractMapSequence.this.map.entrySet();
        }
    }

    private static class EntryMapping<F, S>
    implements IMapping<F, S> {
        private final Map.Entry<F, S> entry;

        public EntryMapping(Map.Entry<F, S> entry) {
            this.entry = entry;
        }

        @Override
        public F key() {
            return this.entry.getKey();
        }

        @Override
        public S value() {
            return this.entry.getValue();
        }

        @Override
        public S value(S newValue) {
            return this.entry.setValue(newValue);
        }

        @Override
        public Map.Entry<F, S> toEntry() {
            return this.entry;
        }

        public int hashCode() {
            return this.entry.hashCode();
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (this.getClass() == that.getClass()) {
                return this.entry.equals(((EntryMapping)that).entry);
            }
            if (that instanceof IMapping) {
                return this.eq(this.key(), ((IMapping)that).key()) && this.eq(this.value(), ((IMapping)that).value());
            }
            return false;
        }

        public String toString() {
            return String.valueOf(this.key()) + "=" + String.valueOf(this.value());
        }

        private boolean eq(Object a, Object b) {
            return a == b || a != null && a.equals(b);
        }
    }
}

