/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime;

import com.vertabelo.autolayout_tool.repackaged.javaslang.Function2;
import com.vertabelo.autolayout_tool.repackaged.mps.baseLanguage.closures.runtime.AdapterClass;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IEnumerator;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IterableUtils;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SelectComparator;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl.ComparingSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl.ConcatingSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl.EnumeratorIterator;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl.FilteringSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl.LimitedCardinalitySequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl.NegateWhereFilter;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl.NullSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl.OfTypeSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl.PagingSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl.ReversingSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl.SelectingSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl.SortingSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl.TranslatingSequence;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class AbstractSequence<T>
implements ISequence<T>,
Iterable<T> {
    public static final boolean USE_NULL_SEQUENCE = true;
    public static final boolean IGNORE_NULL_VALUES = false;
    public static final boolean NULL_WHEN_EMPTY = true;
    public static final boolean NULL_ARRAY_IS_SINGLETON = true;
    protected static final Object[] ARRAY_WITH_NULL = new Object[]{null};

    @Override
    public ISequence<T> where(@AdapterClass(value="IWhereFilter") Predicate<? super T> filter) {
        return new FilteringSequence<Object>(this, x -> filter.test(x));
    }

    @Override
    public T findFirst(@AdapterClass(value="IWhereFilter") Predicate<? super T> filter) {
        return this.where(filter).first();
    }

    @Override
    public T findLast(@AdapterClass(value="IWhereFilter") Predicate<? super T> filter) {
        return this.where(filter).last();
    }

    @Override
    public boolean any(@AdapterClass(value="IWhereFilter") Predicate<? super T> filter) {
        return this.where(filter).isNotEmpty();
    }

    @Override
    public boolean all(@AdapterClass(value="IWhereFilter") Predicate<? super T> filter) {
        return this.where(new NegateWhereFilter<T>(filter)).isEmpty();
    }

    @Override
    public <U> ISequence<U> translate(@AdapterClass(value="ITranslator2") Function<? super T, ? extends Iterable<U>> translator) {
        return new TranslatingSequence(this, translator);
    }

    @Override
    public <U> ISequence<U> select(@AdapterClass(value="ISelector") Function<? super T, ? extends U> selector) {
        return new SelectingSequence<T, U>(this, selector);
    }

    @Override
    public <U> ISequence<U> ofType(Class<U> type) {
        return new OfTypeSequence(this, type);
    }

    @Override
    public ISequence<T> sort(@AdapterClass(value="ISelector") Function<? super T, ? extends Comparable<?>> selector, boolean ascending) {
        return new SortingSequence<T>(this, new SelectComparator<T>(selector), ascending);
    }

    @Override
    public ISequence<T> alsoSort(@AdapterClass(value="ISelector") Function<? super T, ? extends Comparable<?>> selector, boolean ascending) {
        return this.sort(selector, ascending);
    }

    @Override
    public ISequence<T> sort(Comparator<? super T> comparator, boolean ascending) {
        return new SortingSequence<T>(this, comparator, ascending);
    }

    @Override
    public ISequence<T> distinct() {
        return new LimitedCardinalitySequence(this, 1);
    }

    @Override
    public void visitAll(@AdapterClass(value="IVisitor") Function<? super T, Void> visitor) {
        IterableUtils.visitAll(this.toIterable(), visitor);
    }

    @Override
    public ISequence<T> take(int length) {
        return new PagingSequence(this, PagingSequence.Page.TAKE, length);
    }

    @Override
    public ISequence<T> skip(int length) {
        return new PagingSequence(this, PagingSequence.Page.SKIP, length);
    }

    @Override
    public ISequence<T> cut(int length) {
        return new PagingSequence(this, PagingSequence.Page.CUT, length);
    }

    @Override
    public ISequence<T> tail(int length) {
        return new PagingSequence(this, PagingSequence.Page.TAIL, length);
    }

    @Override
    public ISequence<T> page(int skip, int skipplustake) {
        int take = skipplustake - skip;
        return this.skip(skip).take(take);
    }

    @Override
    public ISequence<T> concat(ISequence<? extends T> that) {
        if (that == null) {
            return this;
        }
        return new ConcatingSequence<T>(this, that);
    }

    @Override
    public ISequence<T> intersect(ISequence<? extends T> that) {
        if (that == null) {
            return NullSequence.instance();
        }
        return new ComparingSequence<T>(this, that, ComparingSequence.Kind.INTERSECTION);
    }

    @Override
    public ISequence<T> subtract(ISequence<? extends T> that) {
        if (that == null) {
            return this;
        }
        return new ComparingSequence<T>(this, that, ComparingSequence.Kind.SUBSTRACTION);
    }

    @Override
    public ISequence<T> union(ISequence<? extends T> that) {
        if (that == null) {
            return this;
        }
        return new ComparingSequence<T>(this, that, ComparingSequence.Kind.UNION);
    }

    @Override
    public ISequence<T> disjunction(ISequence<? extends T> that) {
        if (that == null) {
            return this;
        }
        return new ComparingSequence<T>(this, that, ComparingSequence.Kind.DISJUNCTION);
    }

    @Override
    public ISequence<T> reverse() {
        return new ReversingSequence(this);
    }

    @Override
    public boolean contains(Object o) {
        return IterableUtils.contains(this.toIterable(), o);
    }

    @Override
    public boolean containsSequence(ISequence<? extends T> that) {
        if (that == null) {
            return false;
        }
        return this.intersect(that).disjunction(that).isEmpty();
    }

    @Override
    public int indexOf(T t) {
        return IterableUtils.indexOf(this.toIterable(), t);
    }

    @Override
    public int lastIndexOf(T t) {
        return IterableUtils.lastIndexOf(this.toIterable(), t);
    }

    @Override
    public int count() {
        return IterableUtils.count(this.toIterable());
    }

    @Override
    public boolean isEmpty() {
        return IterableUtils.isEmpty(this.toIterable());
    }

    @Override
    public boolean isNotEmpty() {
        return IterableUtils.isNotEmpty(this.toIterable());
    }

    @Override
    public T first() {
        return IterableUtils.first(this.toIterable());
    }

    @Override
    public T last() {
        return IterableUtils.last(this.toIterable());
    }

    @Override
    public T reduceLeft(Function2<? super T, ? super T, ? extends T> comb) {
        return IterableUtils.reduceLeft(this, comb);
    }

    @Override
    public T reduceRight(Function2<? super T, ? super T, ? extends T> comb) {
        return IterableUtils.reduceRight(this.reverse(), comb);
    }

    @Override
    public <S> S foldLeft(S seed, Function2<? super S, ? super T, ? extends S> comb) {
        return IterableUtils.foldLeft(this, seed, comb);
    }

    @Override
    public <S> S foldRight(S seed, Function2<? super T, ? super S, ? extends S> comb) {
        return IterableUtils.foldRight(this.reverse(), seed, comb);
    }

    @Override
    public Iterable<T> toIterable() {
        return this;
    }

    @Override
    public IListSequence<T> toListSequence() {
        return ListSequence.fromIterable(this.toIterable());
    }

    @Override
    public T[] toGenericArray() {
        return this.toListSequence().toGenericArray();
    }

    @Override
    public T[] toGenericArray(Class<T> runtimeClass) {
        return this.toListSequence().toGenericArray(runtimeClass);
    }

    @Override
    public IEnumerator<T> enumerator() {
        return EnumeratorIterator.fromIterator(this.toIterable().iterator());
    }

    public String toString() {
        Iterable<T> iterable = this.toIterable();
        if (iterable == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder("[");
        String sep = "";
        for (T t : iterable) {
            sb.append(sep).append(String.valueOf(t));
            sep = ", ";
        }
        sb.append("]");
        return sb.toString();
    }
}

