/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime;

import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.AbstractCollectionSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.CollectionUtils;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ICollectionSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.Sequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl.NullCollectionSequence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class CollectionSequence<T>
extends AbstractCollectionSequence<T>
implements ICollectionSequence<T>,
Collection<T>,
Serializable {
    private static final long serialVersionUID = -5323571231659062625L;

    protected CollectionSequence() {
    }

    @Override
    public ICollectionSequence<T> asUnmodifiable() {
        final Collection unmodifiableCollection = Collections.unmodifiableCollection(this.getCollection());
        return new CollectionSequence<T>(){

            @Override
            protected Collection<T> getCollection() {
                return unmodifiableCollection;
            }
        };
    }

    @Override
    public ICollectionSequence<T> asSynchronized() {
        final Collection synchronizedCollection = CollectionUtils.synchronizedCollection(this.getCollection());
        return new CollectionSequence<T>(){

            @Override
            protected Collection<T> getCollection() {
                return synchronizedCollection;
            }
        };
    }

    public static <U> ICollectionSequence<U> fromCollection(final Collection<U> coll) {
        if (coll == null) {
            return NullCollectionSequence.instance();
        }
        if (coll instanceof ICollectionSequence) {
            return (ICollectionSequence)coll;
        }
        return new CollectionSequence<U>(){

            @Override
            protected Collection<U> getCollection() {
                return coll;
            }
        };
    }

    public static <U> ICollectionSequence<U> fromCollectionWithValues(Collection<U> coll, Iterable<? extends U> it) {
        Collection<U> tmp = coll;
        if (coll == null && it == null) {
            return NullCollectionSequence.instance();
        }
        if (coll == null) {
            tmp = new ArrayList<U>();
        } else if (it == null) {
            return CollectionSequence.fromCollection(coll);
        }
        if (it instanceof Collection) {
            tmp.addAll((Collection)it);
        } else {
            for (U u : it) {
                tmp.add(u);
            }
        }
        if (tmp instanceof ICollectionSequence) {
            return (ICollectionSequence)tmp;
        }
        final Collection<U> myColl = tmp;
        return new CollectionSequence<U>(){

            @Override
            protected Collection<U> getCollection() {
                return myColl;
            }
        };
    }

    public static <U> ICollectionSequence<U> fromCollectionAndArray(Collection<U> coll, U ... array) {
        if (array == null) {
            array = Sequence.nullSingletonArray();
        }
        if (coll == null && array == null) {
            return NullCollectionSequence.instance();
        }
        if (coll == null) {
            coll = new ArrayList<U>();
        } else if (array == null) {
            if (coll instanceof ICollectionSequence) {
                return (ICollectionSequence)coll;
            }
            final Collection<U> myColl = coll;
            return new CollectionSequence<U>(){

                @Override
                protected Collection<U> getCollection() {
                    return myColl;
                }
            };
        }
        List<U> input = List.of(array);
        coll.addAll(input);
        if (coll instanceof ICollectionSequence) {
            return (ICollectionSequence)coll;
        }
        final Collection<U> myColl = coll;
        return new CollectionSequence<U>(){

            @Override
            protected Collection<U> getCollection() {
                return myColl;
            }
        };
    }
}

