/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime;

import com.vertabelo.autolayout_tool.repackaged.mps.baseLanguage.closures.runtime.AdapterClass;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.AbstractQueueSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IDequeSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.Sequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.backports.Deque;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.backports.LinkedList;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl.NullDequeSequence;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public class DequeSequence<T>
extends AbstractQueueSequence<T>
implements Deque<T>,
IDequeSequence<T>,
Serializable {
    private static final long serialVersionUID = 6994676498844479086L;

    protected DequeSequence(Deque<T> deque) {
        super(deque);
    }

    @Override
    public void addFirst(T t) {
        this.getDeque().addFirst(t);
    }

    @Override
    public void addLast(T t) {
        this.getDeque().addLast(t);
    }

    @Override
    public Iterator<T> descendingIterator() {
        return this.getDeque().descendingIterator();
    }

    @Override
    public T getFirst() {
        return this.getDeque().getFirst();
    }

    @Override
    public T getLast() {
        return this.getDeque().getLast();
    }

    @Override
    public boolean offerFirst(T t) {
        return this.getDeque().offerFirst(t);
    }

    @Override
    public boolean offerLast(T t) {
        return this.getDeque().offerLast(t);
    }

    @Override
    public T peekFirst() {
        return this.getDeque().peekFirst();
    }

    @Override
    public T peekLast() {
        return this.getDeque().peekLast();
    }

    @Override
    public T pollFirst() {
        return this.getDeque().pollFirst();
    }

    @Override
    public T pollLast() {
        return this.getDeque().pollLast();
    }

    @Override
    public T pop() {
        return this.getDeque().pop();
    }

    @Override
    public void push(T t) {
        this.getDeque().push(t);
    }

    @Override
    public T removeFirst() {
        return this.getDeque().removeFirst();
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        return this.getDeque().removeFirstOccurrence(o);
    }

    @Override
    public T removeLast() {
        return this.getDeque().removeLast();
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        return this.getDeque().removeLastOccurrence(o);
    }

    @Override
    public T addFirstElement(T t) {
        this.getDeque().addFirst(t);
        return t;
    }

    @Override
    public T removeLastElement() {
        if (this.getDeque().isEmpty()) {
            return null;
        }
        return this.getDeque().removeLast();
    }

    @Override
    public T peekElement() {
        if (this.getDeque().isEmpty()) {
            return null;
        }
        return (T)this.getDeque().peek();
    }

    @Override
    public T popElement() {
        if (this.getDeque().isEmpty()) {
            return null;
        }
        return this.getDeque().pop();
    }

    @Override
    public T pushElement(T t) {
        this.getDeque().push(t);
        return t;
    }

    @Override
    public IDequeSequence<T> addSequence(ISequence<? extends T> seq) {
        return (IDequeSequence)super.addSequence((ISequence)seq);
    }

    @Override
    public IDequeSequence<T> removeSequence(ISequence<? extends T> seq) {
        return (IDequeSequence)super.removeSequence((ISequence)seq);
    }

    @Override
    public IDequeSequence<T> removeWhere(@AdapterClass(value="IWhereFilter") Predicate<? super T> filter) {
        return (IDequeSequence)super.removeWhere((Predicate)filter);
    }

    @Override
    public IDequeSequence<T> asUnmodifiable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IDequeSequence<T> asSynchronized() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Deque<T> toDeque() {
        return this;
    }

    protected Deque<T> getDeque() {
        return (Deque)this.getQueue();
    }

    public static <U> IDequeSequence<U> fromDeque(Deque<U> deque) {
        if (deque == null) {
            return NullDequeSequence.instance();
        }
        if (deque instanceof IDequeSequence) {
            return (IDequeSequence)deque;
        }
        return new DequeSequence<U>(deque);
    }

    public static <U> IDequeSequence<U> fromIterable(Iterable<U> it) {
        if (it == null) {
            return NullDequeSequence.instance();
        }
        if (it instanceof IDequeSequence) {
            return (IDequeSequence)it;
        }
        LinkedList deque = new LinkedList();
        if (it instanceof Collection) {
            deque.addAll((Collection)it);
        } else {
            for (U u : it) {
                deque.add(u);
            }
        }
        return new DequeSequence(deque);
    }

    public static <U> IDequeSequence<U> fromDequeAndArray(Deque<U> deque, U ... array) {
        if (array == null) {
            array = Sequence.nullSingletonArray();
        }
        if (deque == null && array == null) {
            return NullDequeSequence.instance();
        }
        if (deque == null) {
            deque = new LinkedList<U>();
        } else if (array == null) {
            if (deque instanceof IDequeSequence) {
                return (IDequeSequence)deque;
            }
            return new DequeSequence<U>(deque);
        }
        List<U> input = List.of(array);
        deque.addAll(input);
        if (deque instanceof IDequeSequence) {
            return (IDequeSequence)deque;
        }
        return new DequeSequence<U>(deque);
    }

    public static <U> IDequeSequence<U> fromDequeWithValues(Deque<U> deque, Iterable<? extends U> it) {
        Deque<U> tmp = deque;
        if (deque == null && it == null) {
            return NullDequeSequence.instance();
        }
        if (deque == null) {
            tmp = new LinkedList<U>();
        } else if (it == null) {
            return DequeSequence.fromDeque(deque);
        }
        if (it instanceof Collection) {
            tmp.addAll((Collection)it);
        } else {
            for (U u : it) {
                tmp.add(u);
            }
        }
        if (tmp instanceof IDequeSequence) {
            return (IDequeSequence)tmp;
        }
        return new DequeSequence<U>(tmp);
    }
}

