/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime;

import com.vertabelo.autolayout_tool.repackaged.javaslang.Function2;
import com.vertabelo.autolayout_tool.repackaged.mps.baseLanguage.closures.runtime.AdapterClass;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.StopIteratingException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;

public class IterableUtils {
    public static <E> void visitAll(Iterable<E> seq, @AdapterClass(value="IVisitor") Function<? super E, Void> visitor) {
        Iterator<E> it = seq.iterator();
        while (it.hasNext()) {
            try {
                visitor.apply(it.next());
            }
            catch (StopIteratingException stop) {
                break;
            }
        }
    }

    public static <E> boolean contains(Iterable<E> seq, E e) {
        return IterableUtils.indexOf(seq, e) >= 0;
    }

    public static <E> int indexOf(Iterable<E> seq, E e) {
        int index = 0;
        Iterator<E> it = seq.iterator();
        while (it.hasNext()) {
            if (IterableUtils.eq(it.next(), e)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static <E> int lastIndexOf(Iterable<E> seq, E e) {
        int lastIndex = -1;
        int index = 0;
        Iterator<E> it = seq.iterator();
        while (it.hasNext()) {
            if (IterableUtils.eq(it.next(), e)) {
                lastIndex = index;
            }
            ++index;
        }
        return lastIndex;
    }

    public static <E> int count(Iterable<E> seq) {
        int count = 0;
        Iterator<E> it = seq.iterator();
        while (it.hasNext()) {
            ++count;
            it.next();
        }
        return count;
    }

    public static <E> boolean isEmpty(Iterable<E> seq) {
        return !seq.iterator().hasNext();
    }

    public static <E> boolean isNotEmpty(Iterable<E> seq) {
        return seq.iterator().hasNext();
    }

    public static <E> E first(Iterable<E> seq) {
        Iterator<E> it = seq.iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public static <E> E last(Iterable<E> seq) {
        E last = null;
        boolean hasLast = false;
        Iterator<E> it = seq.iterator();
        if (!it.hasNext()) {
            return null;
        }
        while (it.hasNext()) {
            last = it.next();
            hasLast = true;
        }
        if (hasLast) {
            return last;
        }
        throw new NoSuchElementException("Empty iterator");
    }

    public static String join(Iterable<? extends String> seq, String delimiter) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        Iterator<? extends String> it = seq.iterator();
        while (it.hasNext()) {
            sb.append(sep).append(it.next());
            sep = delimiter;
        }
        return sb.toString();
    }

    public static <T> T reduceLeft(Iterable<T> seq, Function2<? super T, ? super T, ? extends T> combinator) {
        Iterator<T> it = seq.iterator();
        if (!it.hasNext()) {
            return null;
        }
        T left = it.next();
        while (it.hasNext()) {
            left = combinator.apply(left, it.next());
        }
        return left;
    }

    public static <T> T reduceRight(Iterable<T> revSeq, Function2<? super T, ? super T, ? extends T> combinator) {
        Iterator<T> it = revSeq.iterator();
        if (!it.hasNext()) {
            return null;
        }
        T right = it.next();
        while (it.hasNext()) {
            right = combinator.apply(it.next(), right);
        }
        return right;
    }

    public static <T, S> S foldLeft(Iterable<T> seq, S seed, Function2<? super S, ? super T, ? extends S> combinator) {
        S s = seed;
        Iterator<T> it = seq.iterator();
        while (it.hasNext()) {
            s = combinator.apply(s, it.next());
        }
        return s;
    }

    public static <T, S> S foldRight(Iterable<T> revSeq, S seed, Function2<? super T, ? super S, ? extends S> combinator) {
        S s = seed;
        Iterator<T> it = revSeq.iterator();
        while (it.hasNext()) {
            s = combinator.apply(it.next(), s);
        }
        return s;
    }

    private static boolean eq(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }
}

