/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime;

import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.AbstractListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.CollectionUtils;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.Sequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl.NullListSequence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ListSequence<T>
extends AbstractListSequence<T>
implements IListSequence<T>,
List<T>,
Serializable {
    private static final long serialVersionUID = 7823717404349215342L;
    private List<T> list;

    protected ListSequence(List<T> list) {
        super(list);
    }

    protected ListSequence(ListSequence<T> other) {
        super(other);
    }

    @Override
    public IListSequence<T> reversedList() {
        ListSequence<T> reversed = new ListSequence<T>(this);
        reversed._reverse();
        return reversed;
    }

    @Override
    public IListSequence<T> subListSequence(int fromIdx, int upToIdx) {
        return new ListSequence(this.getList().subList(fromIdx, upToIdx));
    }

    @Override
    public IListSequence<T> headListSequence(int upToIdx) {
        return new ListSequence(this.getList().subList(0, upToIdx));
    }

    @Override
    public IListSequence<T> tailListSequence(int fromIdx) {
        return new ListSequence(this.getList().subList(fromIdx, this.getList().size()));
    }

    @Override
    public IListSequence<T> asUnmodifiable() {
        return new ListSequence(Collections.unmodifiableList(this.getList()));
    }

    @Override
    public IListSequence<T> asSynchronized() {
        return new ListSequence<T>(CollectionUtils.synchronizedList(this.getList()));
    }

    public static <U> IListSequence<U> fromArray(U ... array) {
        if (array == null) {
            return NullListSequence.instance();
        }
        return ListSequence.fromListAndArray(new ArrayList(), array);
    }

    public static <U> IListSequence<U> fromList(List<U> list) {
        if (list == null) {
            return NullListSequence.instance();
        }
        if (list instanceof IListSequence) {
            return (IListSequence)list;
        }
        return new ListSequence<U>(list);
    }

    public static <U> IListSequence<U> fromListAndArray(List<U> list, U ... array) {
        if (array == null) {
            array = Sequence.nullSingletonArray();
        }
        if (list == null && array == null) {
            return NullListSequence.instance();
        }
        if (list == null) {
            list = new ArrayList<U>();
        } else if (array == null) {
            if (list instanceof IListSequence) {
                return (IListSequence)list;
            }
            return new ListSequence<U>(list);
        }
        List<U> input = List.of(array);
        list.addAll(input);
        if (list instanceof IListSequence) {
            return (IListSequence)list;
        }
        return new ListSequence<U>(list);
    }

    public static <U> IListSequence<U> fromIterable(Iterable<U> it) {
        if (it == null) {
            return NullListSequence.instance();
        }
        if (it instanceof IListSequence) {
            return (IListSequence)it;
        }
        ArrayList<U> list = new ArrayList<U>();
        if (it instanceof Collection) {
            list.addAll((Collection)it);
        } else {
            for (U u : it) {
                list.add(u);
            }
        }
        return new ListSequence(list);
    }

    public static <U> IListSequence<U> fromListWithValues(List<U> list, Iterable<? extends U> it) {
        List<U> tmp = list;
        if (list == null && it == null) {
            return NullListSequence.instance();
        }
        if (list == null) {
            tmp = new ArrayList<U>();
        } else if (it == null) {
            return ListSequence.fromList(list);
        }
        if (it instanceof Collection) {
            tmp.addAll((Collection)it);
        } else {
            for (U u : it) {
                tmp.add(u);
            }
        }
        if (tmp instanceof IListSequence) {
            return (IListSequence)tmp;
        }
        return new ListSequence<U>(tmp);
    }
}

