/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime;

import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.AbstractMapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IMapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IMapping;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl.NullMapSequence;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class MapSequence<U, V>
extends AbstractMapSequence<U, V>
implements IMapSequence<U, V>,
Map<U, V>,
Serializable {
    private static final long serialVersionUID = -3900727585622019317L;

    protected MapSequence(Map<U, V> map) {
        super(map);
    }

    public static <P, Q> MapSequenceInitializer<P, Q> fromKeysArray(P ... keys) {
        HashMap map = new HashMap();
        return new MapSequenceInitializer(new MapSequence(map), keys);
    }

    public static <P, Q> MapSequenceInitializer<P, Q> fromMapAndKeysArray(Map<P, Q> map, P ... keys) {
        return new MapSequenceInitializer<P, Q>(new MapSequence<P, Q>(map), keys);
    }

    public static <P, Q> IMapSequence<P, Q> fromArray(IMapping<P, Q> ... mappings) {
        HashMap<P, Q> map = new HashMap<P, Q>();
        for (IMapping<P, Q> mp : mappings) {
            map.put(mp.key(), mp.value());
        }
        return new MapSequence(map);
    }

    public static <P, Q> IMapSequence<P, Q> fromIterable(Iterable<IMapping<P, Q>> iterable) {
        if (iterable instanceof IMapSequence) {
            return (IMapSequence)iterable;
        }
        HashMap<P, Q> map = new HashMap<P, Q>();
        for (IMapping<P, Q> mpng : iterable) {
            map.put(mpng.key(), mpng.value());
        }
        return new MapSequence(map);
    }

    public static <P, Q> IMapSequence<P, Q> fromMap(Map<P, Q> map) {
        if (map == null) {
            return NullMapSequence.INSTANCE;
        }
        if (map instanceof IMapSequence) {
            return (IMapSequence)map;
        }
        return new MapSequence<P, Q>(map);
    }

    public static class MapSequenceInitializer<P, Q> {
        private final P[] keys;
        private final IMapSequence<P, Q> mapSeq;

        protected MapSequenceInitializer(IMapSequence<P, Q> mapSeq, P ... keys) {
            this.mapSeq = mapSeq;
            this.keys = keys;
        }

        public IMapSequence<P, Q> withValues(Q ... values) {
            for (int i = 0; i < this.keys.length && i < values.length; ++i) {
                this.mapSeq.put(this.keys[i], values[i]);
            }
            return this.mapSeq;
        }
    }
}

