/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime;

import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.AbstractQueueSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IQueueSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.Sequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl.NullQueueSequence;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class QueueSequence<T>
extends AbstractQueueSequence<T>
implements Queue<T>,
IQueueSequence<T>,
Serializable {
    private static final long serialVersionUID = 4639602987002419231L;

    protected QueueSequence(Queue<T> queue) {
        super(queue);
    }

    public static <U> IQueueSequence<U> fromQueue(Queue<U> queue) {
        if (queue == null) {
            return NullQueueSequence.instance();
        }
        if (queue instanceof IQueueSequence) {
            return (IQueueSequence)queue;
        }
        return new QueueSequence<U>(queue);
    }

    public static <U> IQueueSequence<U> fromIterable(Iterable<U> it) {
        if (it == null) {
            return NullQueueSequence.instance();
        }
        if (it instanceof IQueueSequence) {
            return (IQueueSequence)it;
        }
        LinkedList<U> queue = new LinkedList<U>();
        if (it instanceof Collection) {
            queue.addAll((Collection)it);
        } else {
            for (U u : it) {
                queue.add(u);
            }
        }
        return new QueueSequence(queue);
    }

    public static <U> IQueueSequence<U> fromQueueAndArray(Queue<U> queue, U ... array) {
        if (array == null) {
            array = Sequence.nullSingletonArray();
        }
        if (queue == null && array == null) {
            return NullQueueSequence.instance();
        }
        if (queue == null) {
            queue = new LinkedList<U>();
        } else if (array == null) {
            if (queue instanceof IQueueSequence) {
                return (IQueueSequence)queue;
            }
            return new QueueSequence<U>(queue);
        }
        List<U> input = List.of(array);
        queue.addAll(input);
        if (queue instanceof IQueueSequence) {
            return (IQueueSequence)queue;
        }
        return new QueueSequence<U>(queue);
    }

    public static <U> IQueueSequence<U> fromQueueWithValues(Queue<U> queue, Iterable<? extends U> it) {
        Queue<U> tmp = queue;
        if (queue == null && it == null) {
            return NullQueueSequence.instance();
        }
        if (queue == null) {
            tmp = new LinkedList<U>();
        } else if (it == null) {
            return QueueSequence.fromQueue(queue);
        }
        if (it instanceof Collection) {
            tmp.addAll((Collection)it);
        } else {
            for (U u : it) {
                tmp.add(u);
            }
        }
        if (tmp instanceof IQueueSequence) {
            return (IQueueSequence)tmp;
        }
        return new QueueSequence<U>(tmp);
    }
}

