/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime;

import com.vertabelo.autolayout_tool.repackaged.mps.baseLanguage.closures.runtime.AdapterClass;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.AbstractSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl.BasicSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl.NullSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl.NullSetSequence;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;

public abstract class Sequence<T>
extends AbstractSequence<T>
implements ISequence<T>,
Iterable<T> {
    public static final boolean USE_NULL_SEQUENCE = true;
    public static final boolean IGNORE_NULL_VALUES = false;
    public static final boolean NULL_WHEN_EMPTY = true;
    public static final boolean NULL_ARRAY_IS_SINGLETON = true;
    protected static final Object[] ARRAY_WITH_NULL = new Object[]{null};

    @Override
    public String toString() {
        Iterable iterable = this.toIterable();
        if (iterable == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder("[");
        String sep = "";
        for (Object t : iterable) {
            sb.append(sep).append(String.valueOf(t));
            sep = ", ";
        }
        sb.append("]");
        return sb.toString();
    }

    protected static <U> U[] nullSingletonArray() {
        return ARRAY_WITH_NULL;
    }

    public static <U> ISequence<U> emptySequence() {
        return NullSetSequence.instance();
    }

    public static <U> ISequence<U> fromArray(U ... array) {
        if (array == null) {
            return NullSequence.instance();
        }
        return new BasicSequence<U>(List.of(array));
    }

    public static <U> ISequence<U> fromClosure(@AdapterClass(value="ISequenceClosure") Supplier<? extends Iterable<U>> cls) {
        return Sequence.fromIterable(cls.get());
    }

    public static <U> ISequence<U> fromIterable(Iterable<U> iterable) {
        if (iterable == null) {
            return NullSequence.instance();
        }
        if (iterable instanceof ISequence) {
            return (ISequence)iterable;
        }
        return new BasicSequence<U>(iterable);
    }

    public static <U> ISequence<U> singleton(U value) {
        return new BasicSequence<U>(Collections.singleton(value));
    }
}

