/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime;

import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.AbstractSetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.Sequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl.NullSetSequence;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SetSequence<T>
extends AbstractSetSequence<T>
implements ISetSequence<T>,
Set<T>,
Serializable {
    private static final long serialVersionUID = 541380543157727748L;

    protected SetSequence(Set<T> set) {
        super(set);
    }

    @Override
    public ISetSequence<T> asUnmodifiable() {
        return new SetSequence(Collections.unmodifiableSet(this.getSet()));
    }

    @Override
    public ISetSequence<T> asSynchronized() {
        return new SetSequence(Collections.unmodifiableSet(this.getSet()));
    }

    public static <U> ISetSequence<U> fromArray(U ... array) {
        if (array == null) {
            return NullSetSequence.instance();
        }
        return SetSequence.fromSetAndArray(new HashSet(), array);
    }

    public static <U> ISetSequence<U> fromSet(Set<U> set) {
        if (set == null) {
            return NullSetSequence.instance();
        }
        if (set instanceof ISetSequence) {
            return (ISetSequence)set;
        }
        return new SetSequence<U>(set);
    }

    public static <U> ISetSequence<U> fromSetAndArray(Set<U> set, U ... array) {
        if (array == null) {
            array = Sequence.nullSingletonArray();
        }
        if (set == null && array == null) {
            return NullSetSequence.instance();
        }
        if (set == null) {
            set = new HashSet<U>();
        } else if (array == null) {
            if (set instanceof ISetSequence) {
                return (ISetSequence)set;
            }
            return new SetSequence<U>(set);
        }
        List<U> input = List.of(array);
        set.addAll(input);
        if (set instanceof ISetSequence) {
            return (ISetSequence)set;
        }
        return new SetSequence<U>(set);
    }

    public static <U> ISetSequence<U> fromIterable(Iterable<U> it) {
        if (it == null) {
            return NullSetSequence.instance();
        }
        if (it instanceof ISetSequence) {
            return (ISetSequence)it;
        }
        HashSet<U> set = new HashSet<U>();
        if (it instanceof Collection) {
            set.addAll((Collection)it);
        } else {
            for (U u : it) {
                set.add(u);
            }
        }
        return new SetSequence(set);
    }

    public static <U> ISetSequence<U> fromSetWithValues(Set<U> set, Iterable<? extends U> it) {
        Set<U> tmp = set;
        if (set == null && it == null) {
            return NullSetSequence.instance();
        }
        if (set == null) {
            tmp = new HashSet<U>();
        } else if (it == null) {
            return SetSequence.fromSet(set);
        }
        if (it instanceof Collection) {
            tmp.addAll((Collection)it);
        } else {
            for (U u : it) {
                tmp.add(u);
            }
        }
        if (tmp instanceof ISetSequence) {
            return (ISetSequence)tmp;
        }
        return new SetSequence<U>(tmp);
    }
}

