/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime;

import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.AbstractMapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IMapping;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISortedMapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl.NullSortedMapSequence;
import java.io.Serializable;
import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;

public class SortedMapSequence<U, V>
extends AbstractMapSequence<U, V>
implements ISortedMapSequence<U, V>,
SortedMap<U, V>,
Serializable {
    private static final long serialVersionUID = 4148607188257567855L;

    protected SortedMapSequence(SortedMap<U, V> map) {
        super(map);
    }

    @Override
    public Comparator<? super U> comparator() {
        return this.getMap().comparator();
    }

    @Override
    public U firstKey() {
        return (U)this.getMap().firstKey();
    }

    @Override
    public ISortedMapSequence<U, V> headMap(U toKey) {
        return SortedMapSequence.fromMap(this.getMap().headMap(toKey));
    }

    @Override
    public U lastKey() {
        return (U)this.getMap().lastKey();
    }

    @Override
    public ISortedMapSequence<U, V> subMap(U fromKey, U toKey) {
        return SortedMapSequence.fromMap(this.getMap().subMap(fromKey, toKey));
    }

    @Override
    public ISortedMapSequence<U, V> tailMap(U fromKey) {
        return SortedMapSequence.fromMap(this.getMap().tailMap(fromKey));
    }

    @Override
    protected SortedMap<U, V> getMap() {
        return (SortedMap)super.getMap();
    }

    public static <P, Q> SortedMapSequenceInitializer<P, Q> fromKeysArray(P ... keys) {
        TreeMap map = new TreeMap();
        return new SortedMapSequenceInitializer(new SortedMapSequence(map), keys);
    }

    public static <P, Q> SortedMapSequenceInitializer<P, Q> fromMapAndKeysArray(SortedMap<P, Q> map, P ... keys) {
        return new SortedMapSequenceInitializer<P, Q>(new SortedMapSequence<P, Q>(map), keys);
    }

    public static <P, Q> ISortedMapSequence<P, Q> fromArray(IMapping<P, Q> ... mappings) {
        TreeMap<P, Q> map = new TreeMap<P, Q>();
        for (IMapping<P, Q> mp : mappings) {
            map.put(mp.key(), mp.value());
        }
        return new SortedMapSequence(map);
    }

    public static <P, Q> ISortedMapSequence<P, Q> fromIterable(Iterable<IMapping<P, Q>> iterable) {
        if (iterable instanceof ISortedMapSequence) {
            return (ISortedMapSequence)iterable;
        }
        TreeMap<P, Q> map = new TreeMap<P, Q>();
        for (IMapping<P, Q> mpng : iterable) {
            map.put(mpng.key(), mpng.value());
        }
        return new SortedMapSequence(map);
    }

    public static <P, Q> ISortedMapSequence<P, Q> fromMap(SortedMap<P, Q> map) {
        if (map == null) {
            return NullSortedMapSequence.INSTANCE;
        }
        if (map instanceof ISortedMapSequence) {
            return (ISortedMapSequence)map;
        }
        return new SortedMapSequence<P, Q>(map);
    }

    public static class SortedMapSequenceInitializer<P, Q>
    extends MapSequence.MapSequenceInitializer<P, Q> {
        private SortedMapSequenceInitializer(ISortedMapSequence<P, Q> mapSeq, P ... keys) {
            super(mapSeq, keys);
        }

        @Override
        public ISortedMapSequence<P, Q> withValues(Q ... values) {
            return (ISortedMapSequence)super.withValues(values);
        }
    }
}

