/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl;

import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IEnumerator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class EnumeratorIterator<T>
implements IEnumerator.Iterator<T> {
    private final Iterator<T> delegate;
    private T current;
    private boolean hasCurrent = false;

    private EnumeratorIterator(Iterator<T> iterator) {
        if (iterator == null) {
            throw new NullPointerException();
        }
        this.delegate = iterator;
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public T next() {
        this.primMoveNext();
        return this.primCurrent();
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }

    @Override
    public T current() {
        return this.primCurrent();
    }

    @Override
    public boolean moveNext() {
        return this.primMoveNext();
    }

    private T primCurrent() {
        if (!this.hasCurrent) {
            throw new NoSuchElementException();
        }
        return this.current;
    }

    private boolean primMoveNext() {
        this.hasCurrent = this.delegate.hasNext();
        this.current = this.hasCurrent ? this.delegate.next() : null;
        return this.hasCurrent;
    }

    public static <U> IEnumerator.Iterator<U> fromIterator(Iterator<U> itr) {
        if (itr instanceof IEnumerator.Iterator) {
            return (IEnumerator.Iterator)itr;
        }
        return new EnumeratorIterator<U>(itr);
    }

    protected static class Empty<U>
    implements IEnumerator.Iterator<U> {
        private static Empty<Object> INSTANCE = new Empty();

        protected Empty() {
        }

        @Override
        public U current() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public boolean moveNext() {
            return false;
        }

        @Override
        public U next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public static <V> Empty<V> instance() {
            return INSTANCE;
        }
    }
}

