/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl;

import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl.AbstractChainedSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl.HasNextState;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

public class FilteringSequence<U>
extends AbstractChainedSequence<U, U>
implements Iterable<U> {
    private final Predicate<? super U> filter;

    public FilteringSequence(Iterable<U> input, Predicate<? super U> filter) {
        super(input);
        if (filter == null) {
            throw new NullPointerException();
        }
        this.filter = filter;
    }

    @Override
    public Iterator<U> iterator() {
        return new FilteringIterator();
    }

    private class FilteringIterator
    implements Iterator<U> {
        private Iterator<U> inputIterator;
        private HasNextState hasNext = HasNextState.UNKNOWN;
        private U next;

        private FilteringIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.inputIterator == null) {
                this.init();
            }
            if (this.hasNext.unknown()) {
                this.moveToNext();
            }
            return this.hasNext.hasNext();
        }

        @Override
        public U next() {
            if (this.inputIterator == null) {
                this.init();
            }
            if (this.hasNext.unknown()) {
                this.moveToNext();
            }
            if (!this.hasNext.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.clearNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void init() {
            this.inputIterator = FilteringSequence.this.getInput().iterator();
        }

        private void moveToNext() {
            this.hasNext = HasNextState.AT_END;
            this.next = null;
            while (this.inputIterator.hasNext()) {
                Object tmp = this.inputIterator.next();
                if (!FilteringSequence.this.filter.test(tmp)) continue;
                this.next = tmp;
                this.hasNext = HasNextState.HAS_NEXT;
                break;
            }
        }

        private U clearNext() {
            Object tmp = this.next;
            this.next = null;
            this.hasNext = HasNextState.UNKNOWN;
            return tmp;
        }
    }
}

