/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl;

import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ClassUtils;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl.AbstractChainedSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl.HasNextState;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class OfTypeSequence<U, V>
extends AbstractChainedSequence<U, V>
implements Iterable<V> {
    private Class<V> requestedType;

    public OfTypeSequence(Iterable<U> input, Class<V> reqType) {
        super(input);
        this.requestedType = reqType;
    }

    @Override
    public Iterator<V> iterator() {
        return new OfTypeIterator();
    }

    private boolean isOfType(U input) {
        return ClassUtils.isInstance(this.requestedType, input);
    }

    private V cast(U input) {
        if (ClassUtils.isInstance(this.requestedType, input)) {
            return ClassUtils.cast(this.requestedType, input);
        }
        return null;
    }

    private class OfTypeIterator
    implements Iterator<V> {
        private Iterator<U> inputIterator;
        private HasNextState hasNext = HasNextState.UNKNOWN;
        private V next;

        private OfTypeIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.inputIterator == null) {
                this.init();
            }
            if (this.hasNext.unknown()) {
                this.moveToNext();
            }
            return this.hasNext.hasNext();
        }

        @Override
        public V next() {
            if (this.inputIterator == null) {
                this.init();
            }
            if (this.hasNext.unknown()) {
                this.moveToNext();
            }
            if (!this.hasNext.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.clearNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void init() {
            this.inputIterator = OfTypeSequence.this.getInput().iterator();
        }

        private void moveToNext() {
            this.hasNext = HasNextState.AT_END;
            this.next = null;
            while (this.inputIterator.hasNext()) {
                Object tmp = this.inputIterator.next();
                if (!OfTypeSequence.this.isOfType(tmp)) continue;
                this.hasNext = HasNextState.HAS_NEXT;
                this.next = OfTypeSequence.this.cast(tmp);
                break;
            }
        }

        private V clearNext() {
            Object tmp = this.next;
            this.next = null;
            this.hasNext = HasNextState.UNKNOWN;
            return tmp;
        }
    }
}

