/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl;

import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.AbstractSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.Sequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl.HasNextState;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PagingSequence<U>
extends Sequence<U>
implements Iterable<U> {
    private final AbstractSequence<U> input;
    private final Page page;
    private final int length;

    public PagingSequence(AbstractSequence<U> input, Page page, int length) {
        if (input == null) {
            throw new NullPointerException();
        }
        if (length < 0) {
            throw new IllegalArgumentException("Negative page length");
        }
        this.input = input;
        this.page = page;
        this.length = length;
    }

    @Override
    public Iterator<U> iterator() {
        return new PagingIterator();
    }

    public static enum Page {
        TAKE,
        SKIP,
        TAIL,
        CUT;

    }

    private class PagingIterator
    implements Iterator<U> {
        private Iterator<U> inputIt;
        private HasNextState hasNext = HasNextState.UNKNOWN;
        private U next;
        private int countDown;
        private ArrayList<U> cache;

        private PagingIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.inputIt == null) {
                this.init();
            }
            if (this.hasNext.unknown()) {
                this.moveToNext();
            }
            return this.hasNext.hasNext();
        }

        @Override
        public U next() {
            if (this.inputIt == null) {
                this.init();
            }
            if (this.hasNext.unknown()) {
                this.moveToNext();
            }
            if (!this.hasNext.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.clearNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void init() {
            switch (PagingSequence.this.page.ordinal()) {
                case 0: 
                case 1: {
                    this.inputIt = PagingSequence.this.input.toIterable().iterator();
                    this.countDown = PagingSequence.this.length;
                    break;
                }
                case 2: 
                case 3: {
                    this.cache = new ArrayList();
                    for (Object o : PagingSequence.this.input) {
                        this.cache.add(o);
                    }
                    this.inputIt = this.cache.iterator();
                    this.countDown = Math.max(0, this.cache.size() - PagingSequence.this.length);
                    break;
                }
            }
        }

        private void destroy() {
            switch (PagingSequence.this.page.ordinal()) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    this.cache.clear();
                    break;
                }
            }
        }

        private void moveToNext() {
            if (this.countDown > 0) {
                do {
                    --this.countDown;
                    switch (PagingSequence.this.page.ordinal()) {
                        case 0: 
                        case 3: {
                            this.takeNext();
                            return;
                        }
                        case 1: 
                        case 2: {
                            if (this.skipNext()) break;
                            return;
                        }
                    }
                } while (this.countDown > 0);
            }
            switch (PagingSequence.this.page.ordinal()) {
                case 0: 
                case 3: {
                    this.stop();
                    break;
                }
                case 1: 
                case 2: {
                    this.takeNext();
                    break;
                }
            }
        }

        private U clearNext() {
            Object tmp = this.next;
            this.next = null;
            this.hasNext = HasNextState.UNKNOWN;
            return tmp;
        }

        private boolean skipNext() {
            if (this.inputIt.hasNext()) {
                this.inputIt.next();
                this.next = null;
                return true;
            }
            this.stop();
            return false;
        }

        private void stop() {
            this.hasNext = HasNextState.AT_END;
            this.next = null;
            this.destroy();
        }

        private void takeNext() {
            if (this.inputIt.hasNext()) {
                this.next = this.inputIt.next();
                this.hasNext = HasNextState.HAS_NEXT;
            } else {
                this.stop();
            }
        }
    }
}

