/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl;

import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.AbstractSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SelectComparator;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.Sequence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;

public class SortingSequence<U>
extends Sequence<U>
implements Iterable<U> {
    private final AbstractSequence<U> input;
    private final Comparator<? super U> comparator;

    public SortingSequence(AbstractSequence<U> input, Comparator<? super U> comparator, boolean ascending) {
        if (input == null || comparator == null) {
            throw new NullPointerException();
        }
        this.input = input;
        this.comparator = ascending ? comparator : new InversedComparator<U>(comparator);
    }

    public SortingSequence(AbstractSequence<U> input, Comparator<U> comparator) {
        if (input == null || comparator == null) {
            throw new NullPointerException();
        }
        this.input = input;
        this.comparator = comparator;
    }

    @Override
    public Iterator<U> iterator() {
        List<U> sortedInput = this.inputSortedWithSelector();
        return new UnmodifiableIterator<U>(sortedInput.listIterator());
    }

    @Override
    public ISequence<U> alsoSort(Function<? super U, ? extends Comparable<?>> selector, boolean ascending) {
        SelectComparator<? super U> selectComparator = new SelectComparator<U>(selector);
        return new SortingSequence<U>(this.input, new CompoundComparator<U>(this.comparator, ascending ? selectComparator : new InversedComparator<U>(selectComparator)));
    }

    private List<U> inputSortedWithSelector() {
        ArrayList cache = new ArrayList();
        for (Object u : this.input) {
            cache.add(u);
        }
        Object[] array = cache.toArray();
        Arrays.sort(array, this.comparator);
        return List.of(array);
    }

    private static class InversedComparator<T>
    implements Comparator<T> {
        private final Comparator<? super T> primary;

        public InversedComparator(Comparator<? super T> primary) {
            this.primary = primary;
        }

        @Override
        public int compare(T a, T b) {
            return -this.primary.compare(a, b);
        }
    }

    private static class UnmodifiableIterator<U>
    implements Iterator<U> {
        private final ListIterator<U> source;

        public UnmodifiableIterator(ListIterator<U> source) {
            this.source = source;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public U next() {
            return this.source.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class CompoundComparator<T>
    implements Comparator<T> {
        private final Comparator<? super T> secondary;
        private final Comparator<? super T> primary;

        public CompoundComparator(Comparator<? super T> primary, Comparator<? super T> secondary) {
            this.primary = primary;
            this.secondary = secondary;
        }

        @Override
        public int compare(T a, T b) {
            int c = this.primary.compare(a, b);
            return c == 0 ? this.secondary.compare(a, b) : c;
        }
    }
}

