/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl;

import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.StopIteratingException;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl.AbstractChainedSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl.HasNextState;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.impl.NullSequence;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;

public class TranslatingSequence<U, V>
extends AbstractChainedSequence<U, V>
implements Iterable<V> {
    private final Function<? super U, ? extends Iterable<V>> translator;

    public TranslatingSequence(Iterable<U> input, Function<? super U, ? extends Iterable<V>> translator) {
        super(input);
        if (translator == null) {
            throw new NullPointerException();
        }
        this.translator = translator;
    }

    @Override
    public Iterator<V> iterator() {
        return new TranslatingIterator();
    }

    private class TranslatingIterator
    implements Iterator<V> {
        private Iterator<U> inputIt;
        private Iterator<V> transIt;
        private HasNextState hasNext = HasNextState.UNKNOWN;
        private V next;

        private TranslatingIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.inputIt == null) {
                this.init();
            }
            if (this.hasNext.unknown()) {
                this.moveToNext();
            }
            return this.hasNext.hasNext();
        }

        @Override
        public V next() {
            if (this.inputIt == null) {
                this.init();
            }
            if (this.hasNext.unknown()) {
                this.moveToNext();
            }
            if (!this.hasNext.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.clearNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void init() {
            this.inputIt = TranslatingSequence.this.getInput().iterator();
        }

        private void moveToNext() {
            this.hasNext = HasNextState.AT_END;
            this.next = null;
            while (true) {
                try {
                    if (this.transIt != null && this.transIt.hasNext()) {
                        Object tmp = this.transIt.next();
                        this.next = tmp;
                        this.hasNext = HasNextState.HAS_NEXT;
                    }
                }
                catch (StopIteratingException stop) {}
                break;
                if (!this.inputIt.hasNext()) break;
                try {
                    Iterable transSeq = TranslatingSequence.this.translator.apply(this.inputIt.next());
                    if (transSeq == null) {
                        transSeq = NullSequence.instance();
                    }
                    this.transIt = transSeq.iterator();
                }
                catch (StopIteratingException illegal) {
                    throw new IllegalStateException(illegal);
                }
            }
        }

        private V clearNext() {
            Object tmp = this.next;
            this.next = null;
            this.hasNext = HasNextState.UNKNOWN;
            return tmp;
        }
    }
}

