/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.util;

import com.vertabelo.xml.model.DatabaseModel;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;

public enum DatabaseModelCloner {
    INSTANCE;


    public DatabaseModel clone(DatabaseModel databaseModel) {
        return this.unmarshal(this.marshal(databaseModel));
    }

    private String marshal(DatabaseModel databaseModel) {
        try {
            StringWriter os;
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{DatabaseModel.class});
            Marshaller m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            try (StringWriter stringWriter = os = new StringWriter();){
                m.marshal((Object)databaseModel, (Writer)os);
            }
            String xml = os.toString();
            xml = this.removeInvalidCharacters(xml);
            return xml;
        }
        catch (JAXBException | IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private DatabaseModel unmarshal(String xml) {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{DatabaseModel.class});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            return (DatabaseModel)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }

    private String removeInvalidCharacters(String xml) {
        return xml.replaceAll("[\\x00-\\x09\\x11\\x12\\x14-\\x1F\\x7F]", " ");
    }
}

