/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.util;

import com.vertabelo.autolayout_tool.graph.Edge;
import com.vertabelo.autolayout_tool.graph.EdgeType;
import com.vertabelo.autolayout_tool.graph.EdgeView;
import com.vertabelo.autolayout_tool.graph.Graph;
import com.vertabelo.autolayout_tool.graph.GraphBuilder;
import com.vertabelo.autolayout_tool.graph.NPoint;
import com.vertabelo.autolayout_tool.graph.Node;
import com.vertabelo.autolayout_tool.graph.NodeView;
import com.vertabelo.autolayout_tool.repackaged.com.google.common.base.Preconditions;
import com.vertabelo.autolayout_tool.util.GraphRaw;
import com.vertabelo.xml.model.ControlPointsType;
import com.vertabelo.xml.model.DatabaseModel;
import com.vertabelo.xml.model.Point;
import com.vertabelo.xml.model.ReferenceDisplayInfo;
import com.vertabelo.xml.model.TableDisplayInfo;
import com.vertabelo.xml.model.ViewDisplayInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class GraphConverter {
    public Graph toGraph(DatabaseModel databaseModel) {
        NodeView view;
        Node node;
        GraphBuilder builder = new GraphBuilder();
        HashMap<String, Node> nodesMap = new HashMap<String, Node>();
        for (TableDisplayInfo tableDisplay : databaseModel.getTableDisplays().getTableDisplay()) {
            node = new Node(tableDisplay.getId());
            view = node.nodeView();
            view.setWidth((int)tableDisplay.getWidth());
            view.setHeight((int)tableDisplay.getHeight());
            view.setX((int)tableDisplay.getX());
            view.setY((int)tableDisplay.getY());
            nodesMap.put(node.getId(), node);
        }
        for (ViewDisplayInfo viewDisplay : databaseModel.getViewDisplays().getViewDisplay()) {
            node = new Node(viewDisplay.getId());
            view = node.nodeView();
            view.setWidth((int)viewDisplay.getWidth());
            view.setHeight((int)viewDisplay.getHeight());
            view.setX((int)viewDisplay.getX());
            view.setY((int)viewDisplay.getY());
            nodesMap.put(node.getId(), node);
        }
        builder.nodes(nodesMap.values());
        ArrayList<Edge> edgeList = new ArrayList<Edge>();
        for (ReferenceDisplayInfo referenceDisplay : databaseModel.getReferenceDisplays().getReferenceDisplay()) {
            EdgeType type = this.toEdgeViewType(referenceDisplay.getType());
            ArrayList<NPoint> points = new ArrayList<NPoint>();
            for (Point point : referenceDisplay.getControlPoints().getControlPoint()) {
                points.add(new NPoint(point.getX(), point.getY()));
            }
            EdgeView edgeView = new EdgeView(type, points);
            Node fkNode = (Node)nodesMap.get(this.tabDispInfo(referenceDisplay.getFkTableDisplay()).getId());
            Node pkNode = (Node)nodesMap.get(this.tabDispInfo(referenceDisplay.getPkTableDisplay()).getId());
            Edge edge = new Edge(referenceDisplay.getId());
            edge.setEdgeView(edgeView);
            edge.setFk(fkNode);
            edge.setPk(pkNode);
            edgeList.add(edge);
        }
        builder.edges(edgeList);
        return builder.buildNormal();
    }

    public Graph fromRawGraph(GraphRaw graphRaw) {
        HashMap<String, Node> nodes = new HashMap<String, Node>();
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (GraphRaw.Node _node : graphRaw.getNodes()) {
            Node node = new Node(_node.getId());
            node.nodeView().setX(_node.getX());
            node.nodeView().setY(_node.getY());
            node.nodeView().setWidth(_node.getWidth());
            node.nodeView().setHeight(_node.getHeight());
            nodes.put(_node.getId(), node);
        }
        for (GraphRaw.Edge _edge : graphRaw.getEdges()) {
            Edge edge = new Edge(_edge.getId());
            EdgeView edgeView = new EdgeView(_edge.getEdgeType(), _edge.getPoints());
            edge.setEdgeView(edgeView);
            edge.setFk((Node)nodes.get(_edge.getFkId()));
            Preconditions.checkNotNull(edge.getFk());
            edge.setPk((Node)nodes.get(_edge.getPkId()));
            Preconditions.checkNotNull(edge.getPk());
            edges.add(edge);
        }
        return new GraphBuilder().nodes(nodes.values()).edges(edges).buildNormal();
    }

    public GraphRaw toRawGraph(Graph graph) {
        GraphRaw graphRaw = new GraphRaw();
        List<GraphRaw.Node> nodes = graph.getNodes().stream().map(node -> {
            GraphRaw.Node _node = new GraphRaw.Node();
            _node.setId(node.getId());
            _node.setWidth(node.nodeView().getWidth());
            _node.setHeight(node.nodeView().getHeight());
            _node.setX((int)node.nodeView().getX());
            _node.setY((int)node.nodeView().getY());
            return _node;
        }).toList();
        graphRaw.setNodes(nodes);
        List<GraphRaw.Edge> edges = graph.getEdges().stream().map(edge -> {
            GraphRaw.Edge _edge = new GraphRaw.Edge();
            _edge.setId(edge.getId());
            _edge.setEdgeType(edge.getEdgeView().getEdgeType());
            _edge.setPoints(edge.getEdgeView().getPoints());
            _edge.setFkId(edge.getFk().getId());
            _edge.setPkId(edge.getPk().getId());
            return _edge;
        }).toList();
        graphRaw.setEdges(edges);
        return graphRaw;
    }

    private TableDisplayInfo tabDispInfo(Object obj) {
        return (TableDisplayInfo)obj;
    }

    public DatabaseModel toModel(Graph graph, DatabaseModel databaseModel) {
        double newY;
        double newX;
        NodeView view;
        for (TableDisplayInfo tableDisplay : databaseModel.getTableDisplays().getTableDisplay()) {
            view = graph.findNode(tableDisplay.getId()).nodeView();
            newX = view.getX();
            newY = view.getY();
            tableDisplay.setX(0.5 + newX);
            tableDisplay.setY(0.5 + newY);
        }
        for (ViewDisplayInfo viewDisplay : databaseModel.getViewDisplays().getViewDisplay()) {
            view = graph.findNode(viewDisplay.getId()).nodeView();
            newX = view.getX();
            newY = view.getY();
            viewDisplay.setX(0.5 + newX);
            viewDisplay.setY(0.5 + newY);
        }
        for (ReferenceDisplayInfo referenceDisplayInfo : databaseModel.getReferenceDisplays().getReferenceDisplay()) {
            Edge edge = graph.getEdgeById(referenceDisplayInfo.getId());
            Preconditions.checkNotNull(edge);
            EdgeView edgeView = edge.getEdgeView();
            referenceDisplayInfo.setType(this.toControlPointType(edgeView.getEdgeType()));
            List controlPoints = referenceDisplayInfo.getControlPoints().getControlPoint();
            controlPoints.clear();
            edgeView.getPoints().stream().map(nPoint -> {
                Point point = new Point();
                point.setX(nPoint.getX());
                point.setY(nPoint.getY());
                return point;
            }).forEach(controlPoints::add);
        }
        return databaseModel;
    }

    public EdgeType toEdgeViewType(ControlPointsType type) {
        switch (type) {
            case CROSS_3_CP: {
                return EdgeType.CROSS_3_CP;
            }
            case VERTICAL_2_CP: {
                return EdgeType.VERTICAL_2_CP;
            }
            case VERTICAL_4_CP: {
                return EdgeType.VERTICAL_4_CP;
            }
            case HORIZONTAL_2_CP: {
                return EdgeType.HORIZONTAL_2_CP;
            }
            case HORIZONTAL_4_CP: {
                return EdgeType.HORIZONTAL_4_CP;
            }
            case SELF_4_CP: {
                return EdgeType.SELF_4_CP;
            }
            case SELF_5_CP: {
                return EdgeType.SELF_5_CP;
            }
        }
        throw new IllegalArgumentException("Not known control point type" + String.valueOf(type));
    }

    public ControlPointsType toControlPointType(EdgeType type) {
        switch (type) {
            case CROSS_3_CP: {
                return ControlPointsType.CROSS_3_CP;
            }
            case VERTICAL_2_CP: {
                return ControlPointsType.VERTICAL_2_CP;
            }
            case VERTICAL_4_CP: {
                return ControlPointsType.VERTICAL_4_CP;
            }
            case HORIZONTAL_2_CP: {
                return ControlPointsType.HORIZONTAL_2_CP;
            }
            case HORIZONTAL_4_CP: {
                return ControlPointsType.HORIZONTAL_4_CP;
            }
            case SELF_4_CP: {
                return ControlPointsType.SELF_4_CP;
            }
            case SELF_5_CP: {
                return ControlPointsType.SELF_5_CP;
            }
        }
        throw new IllegalArgumentException("Not known control point type" + String.valueOf((Object)type));
    }
}

