/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.util;

import com.vertabelo.autolayout_tool.graph.EdgeType;
import com.vertabelo.autolayout_tool.graph.NPoint;
import com.vertabelo.autolayout_tool.repackaged.com.google.gson.Gson;
import com.vertabelo.autolayout_tool.repackaged.com.google.gson.GsonBuilder;
import java.util.List;
import java.util.Objects;

public class GraphRaw {
    List<Node> nodes;
    List<Edge> edges;

    public List<Node> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<Node> nodes) {
        this.nodes = nodes;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public void setEdges(List<Edge> edges) {
        this.edges = edges;
    }

    public String toJSON() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setPrettyPrinting();
        Gson gson = gsonBuilder.create();
        return gson.toJson(this);
    }

    public static GraphRaw fromJson(String json) {
        Gson gson = new GsonBuilder().create();
        return gson.fromJson(json, GraphRaw.class);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphRaw graphRaw = (GraphRaw)o;
        return Objects.equals(this.nodes, graphRaw.nodes) && Objects.equals(this.edges, graphRaw.edges);
    }

    public int hashCode() {
        return Objects.hash(this.nodes, this.edges);
    }

    public String toString() {
        return "GraphRaw{nodes=" + String.valueOf(this.nodes) + ", edges=" + String.valueOf(this.edges) + "}";
    }

    public static class Edge {
        public String id;
        public String pkId;
        public String fkId;
        public EdgeType edgeType;
        public List<NPoint> points;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getPkId() {
            return this.pkId;
        }

        public void setPkId(String pkId) {
            this.pkId = pkId;
        }

        public String getFkId() {
            return this.fkId;
        }

        public void setFkId(String fkId) {
            this.fkId = fkId;
        }

        public EdgeType getEdgeType() {
            return this.edgeType;
        }

        public void setEdgeType(EdgeType edgeType) {
            this.edgeType = edgeType;
        }

        public List<NPoint> getPoints() {
            return this.points;
        }

        public void setPoints(List<NPoint> points) {
            this.points = points;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Edge edge = (Edge)o;
            return Objects.equals(this.id, edge.id) && Objects.equals(this.pkId, edge.pkId) && Objects.equals(this.fkId, edge.fkId) && this.edgeType == edge.edgeType && Objects.equals(this.points, edge.points);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.id, this.pkId, this.fkId, this.edgeType, this.points});
        }

        public String toString() {
            return "Edge{id='" + this.id + "', pkId='" + this.pkId + "', fkId='" + this.fkId + "', edgeType=" + String.valueOf((Object)this.edgeType) + ", points=" + String.valueOf(this.points) + "}";
        }
    }

    public static class Node {
        public String id;
        public int width;
        public int height;
        public int x;
        public int y;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int y) {
            this.y = y;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return this.width == node.width && this.height == node.height && this.x == node.x && this.y == node.y && Objects.equals(this.id, node.id);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.width, this.height, this.x, this.y);
        }

        public String toString() {
            return "Node{id='" + this.id + "', width=" + this.width + ", height=" + this.height + ", x=" + this.x + ", y=" + this.y + "}";
        }
    }
}

